package orderprocessing;

import java.io.Serializable;
import java.util.StringTokenizer;

/** This class maintains information for an address
 <pre>
 History
 date		description
 -----		-----------
 08/27/07	Creation, break out from customer class
 </pre>
 This class represents addresses, usually customer addresses. It is useful only for
 addresses in the U.S. however.
 */
public class Address implements Serializable, Cloneable {
	
	private String name = "";

	private String street = "";

	private String city = "";

	private String state = "";

	private String zip = "";

	/** Create an address from a set of strings representing the parts of
	 * the address
	 * @param name the customer name
	 * @param street the street address of the customer
	 * @param city the city of the customer
	 * @param state the state (US) of the customer
	 * @param zip the zip code of the customer
	 */
	public Address(String name, String street, String city, String state,
			String zip) {
		if (name != null) {
			this.name = name.trim();
		}
		if (street != null) {
			this.street = street.trim();
		}
		if (city != null) {
			this.city = city.trim();
		}
		if (state != null) {
			this.state = state.trim();
		}
		if (zip != null) {
			this.zip = zip.trim();
		}
	}

	/** Create an address from a single encoded string
	 * @param all the complete address of the customer beginning with the name
	 * @param separator the separator character between fields of all
	 */
	public Address(String all, String separator) {
		StringTokenizer tok = new StringTokenizer(all, separator);
		// Space is not a good separator.
		name = tok.nextToken().trim();
		street = tok.nextToken().trim();
		city = tok.nextToken().trim();
		state = tok.nextToken().trim();
		zip = tok.nextToken().trim();
	}

	public Object clone() {
		return new Address(name, street, city, state, zip);
	}

	public boolean equals(Object other) {
		if (!(other instanceof Address)) {
			return false;
		}
		Address o = (Address) other;
		return name.equals(o.name) && street.equals(o.street)
				&& city.equals(o.city) && state.equals(o.state)
				&& zip.equals(o.zip);
	}

	public int hashCode() {
		return toString().hashCode();
	}

	/** Display this address info on standard output
	 * 
	 */
	public void display() {
		System.out.println(this); // Automatically uses toString.
	}

	// Accessors
	/** Retrieve the name associated with this address
	 * @return the name
	 */
	public String name() {
		return name;
	}

	/** Retrieve the number and street for this address
	 * @return the number and street
	 */
	public String street() {
		return street;
	}

	/** Retrieve the name of the city
	 * @return the city
	 */
	public String city() {
		return city;
	}

	/** Retrieve the state's two character code
	 * @return the state's code
	 * TODO guarantee that it returns a legal code
	 */
	public String state() {
		return state;
	}

	/** retrieve the postal (zip) code for this address
	 * @return the zip code
	 */
	public String zip() {
		return zip;
	}

	/** Change the name associated with this address
	 * @param name the new name
	 */
	// Mutators
	public void name(String name) {
		if (name != null && name.trim() != "") {
			this.name = name.trim();
		}
	}

	/** Change the number and street of this address
	 * @param street the number and street
	 */
	public void street(String street) {
		if (street != null && street.trim() != "") {
			this.street = street.trim();
		}
	}

	/** Change the city associated with this address
	 * @param city the new city
	 */
	public void city(String city) {
		if (city != null && city.trim() != "") {
			this.city = city.trim();
		}
	}

	/** Change the state for this address
	 * @param state the two character code for this addreas.
	 */
	public void state(String state) {
		if (state != null && state.trim() != "") {
			this.state = state.trim();
		}
	}

	/** Change the zip code for this address
	 * @param zip the new zip code
	 */
	public void zip(String zip) {
		if (zip != null && zip.trim() != "") {
			this.zip = zip.trim();
		}
	}

	public String toString() {
		return name + "\n" + street + "\n" + city + "\n" + state + "\n" + zip;
	}

}
