package orderprocessing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/**
 * This class manages inventory and responds to requests from an OrderProcessor
 * In this version it is just a stub. It says that anything is in stock and does
 * no error checking of any kind.
 * 
 * TODO Inventory Manager is just a stub
 */
public class InventoryManager {

	/**
	 * Tells if a given order can be filled now @ param order The OrderItem to
	 * be checked. @ return an OrderItem with the quantity that can be shipped.
	 */
	public OrderItem available(OrderItem order) {
		return (OrderItem) order.clone();
		// Currently assumes anything can be shipped.
	}

	public static InventoryManager standardInventoryManager = new InventoryManager();

	/**
	 * Write the inventory onto an output stream
	 * 
	 * @param out
	 *            the object stream to write to
	 * @throws IOException
	 */
	public static final void close(ObjectOutputStream out) throws IOException { // Nothing yet as there are no Product objects or Inventory Objects.
	}

	/**
	 * Read the inventory into memory at the beginning of a run
	 * 
	 * @param in
	 *            the Object stream to read from
	 * @throws IOException
	 * @throws ClassNotFoundException
	 */
	public static final void open(ObjectInputStream in) throws IOException,
			ClassNotFoundException { // Nothing yet
	}

}
