package orderprocessing;

import org.junit.*;
import static org.junit.Assert.*;
import java.util.ArrayList;
import java.util.Iterator;

/** Test harness for invoices
 * 
 * TODO More tests are needed for invoices
 */
public class InvoiceTest {
	private Invoice i1;

	private ArrayList<String> items;

	private Order o1;

	@Before
	public void setUp() {
		OrderProcessor.open(OrderProcessor.databaseName());//don't close. 
		items = new ArrayList<String>();
		items.add("15~11232~16.95~Widget");
		o1 = OrderProcessor.orderProcessor.newOrder("C5002", "NET 30",
				"default", "default", items, new CalculationCalendar(),
				new CalculationCalendar(), new CalculationCalendar());
		i1 = OrderProcessor.orderProcessor.generateInvoice(o1);
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testItems() {
		Iterator e = i1.shipableItems();
		assertTrue("Empty invoice failure", e.hasNext());
		assertTrue("Non-null invoice item failure", e.next() != null); // non empty and no null elements. 
	}

	@Test
	public void testInfo() {
		assertEquals("Customer failure", i1.customer(), Customer.get("C5002"));
		assertEquals("BillingTerms match failure", o1.billingTerms(),
				BillingTerms.get("NET 30"));
		assertEquals("Ship address failure", o1.shippingAddress(), o1
				.customer().shippingAddress());

		// write some assertions on dates....

		CalculationCalendar today = new CalculationCalendar();
		CalculationCalendar todayPlus7 = today.incrementedBy(
				CalculationCalendar.DATE, 7);
		CalculationCalendar thenPlus10 = o1.requestedShippingDate()
				.incrementedBy(CalculationCalendar.DATE, 10);
		//        System.out.println(today.get(CalculationCalendar.DATE));
		//        System.out.println(o1.requestedShippingDate().get(CalculationCalendar.DATE));
		//        System.out.println(todayPlus7.get(CalculationCalendar.DATE));
		assertTrue("Requested ship date too soon failure", !o1
				.requestedShippingDate().before(todayPlus7));
		assertTrue("Cancel date too soon failure.", !o1.cancelDate().before(
				thenPlus10));

	}

	//	public static Test suite()
	//	{	return new TestSuite(InvoiceTest.class);
	//	}
	//	

}